# Meta Learning Framework TF 2.0

This is a framework which makes it easy to apply meta-learning techniques on different datasets.

## Requirements
Install all gpu dependencies for running TensorFlow on your system <https://www.tensorflow.org/install/gpu>.
Install all required packages with

`pip install -r requirements.txt`

## Running the code
First download dataset which you want to use as described in 
[Datasets](README.md/#Datasets) section.

For each experiment we have a python file to run it. 
For example, run the following command to run MAML on Omniglot dataset.

`python models/maml/maml_omniglot.py` 

For LASIUM experiments you can use any of these models

`python models/lasiummamlgan/mam_gan_omniglot.py`

`python models/lasiummamlvae/maml_vae_omniglot.py`

`python models/lasiumprotonetsgan/protonets_vae_omniglot.py`

`python models/lasiumprotonetsvae/protonets_gan_celeba_progan.py`

Accordingly, you can run these codes on any other dataset as the 
python runner files are provided.

 
## Datasets

### Omniglot
Download [this](https://www.kaggle.com/watesoyan/omniglot/downloads/Omniglot.zip/1) file and extract it into some 
directory on your system.

Make sure to set the address of that directory the same as OMNIGLOT_RAW_DATA_ADDRESS variable in settings.py file.

### Mini-Imagenet 
You can download the dataset from the link provided at the end of 
[this github repo](https://github.com/yaoyao-liu/mini-imagenet-tools).
Go to the bottom of the readme file and choose Download tar files. 
That is the same link as [this](https://meta-transfer-learning.yaoyao-liu.com/download/).
After downloading train, val and test tar files. Extract them into a directory and set the variable
MINI_IMAGENET_RAW_DATA_ADDRESS to the address of that directory.
 

### CelebA
Go to [this website](http://mmlab.ie.cuhk.edu.hk/projects/CelebA.html) in order to download CelebA dataset.
Download identity_CelebA.txt and list_attr_celeba.txt and list_eval_partitions.txt files. 
Download aligned and cropped images. The filename is Img_align_celeba.zip. 
Notes:
1. Images are first roughly aligned using similarity transformation according to the two eye locations;
2. Images are then resized to 218*178;
3. In evaluation status, "0" represents training image, "1" represents validation image, "2" represents testing image;

Put these files in a directory and extract the zip file. There should be 202,599 images in the folder.
Then set the value of CELEBA_RAW_DATA_ADDRESS variable in settings.py to the address of that folder. 
#### CelebA Task 1 - Identity recognition

#### CelebA Task 2- Attribute Assignment
